"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Action,
    ActionPipelineCreate,
    ActionPipelineCreatePlain,
    ActionRelation,
)
from ..utils import parse_query_string


class PipelinesActionsApiService(DevopnessBaseService):
    """
    PipelinesActionsApiService - Auto Generated
    """

    def add_pipeline_action(
        self,
        pipeline_id: int,
        action_pipeline_create: Union[
            ActionPipelineCreate,
            ActionPipelineCreatePlain,
        ],
    ) -> DevopnessResponse[Action]:
        """
        Create an action to run a Pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/actions",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, action_pipeline_create)

        return DevopnessResponse(response, Action)

    def list_pipeline_actions(
        self,
        pipeline_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ActionRelation]]:
        """
        Return a list of pipeline's actions

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/actions",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[ActionRelation])


class PipelinesActionsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    PipelinesActionsApiServiceAsync - Auto Generated
    """

    async def add_pipeline_action(
        self,
        pipeline_id: int,
        action_pipeline_create: Union[
            ActionPipelineCreate,
            ActionPipelineCreatePlain,
        ],
    ) -> DevopnessResponse[Action]:
        """
        Create an action to run a Pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/actions",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, action_pipeline_create)

        return await DevopnessResponse.from_async(response, Action)

    async def list_pipeline_actions(
        self,
        pipeline_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ActionRelation]]:
        """
        Return a list of pipeline's actions

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/actions",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[ActionRelation])
