"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Project,
    ProjectCreate,
    ProjectCreatePlain,
    ProjectOrganizationCreate,
    ProjectOrganizationCreatePlain,
    ProjectRelation,
    ProjectUpdate,
    ProjectUpdatePlain,
)
from ..utils import parse_query_string


class ProjectsApiService(DevopnessBaseService):
    """
    ProjectsApiService - Auto Generated
    """

    def add_organization_project(
        self,
        organization_id: str,
        project_organization_create: Union[
            ProjectOrganizationCreate,
            ProjectOrganizationCreatePlain,
        ],
    ) -> DevopnessResponse[Project]:
        """
        Create a project to a given organization

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/organizations/{organization_id}/projects",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, project_organization_create)

        return DevopnessResponse(response, Project)

    def add_project(
        self,
        project_create: Union[
            ProjectCreate,
            ProjectCreatePlain,
        ],
    ) -> DevopnessResponse[Project]:
        """
        Create a project for the authenticated user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/projects",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, project_create)

        return DevopnessResponse(response, Project)

    def get_project(
        self,
        project_id: int,
    ) -> DevopnessResponse[Project]:
        """
        Get a Project by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, Project)

    def list_organization_projects(
        self,
        organization_id: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ProjectRelation]]:
        """
        List all projects belonging to an organization

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/organizations/{organization_id}/projects",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[ProjectRelation])

    def list_projects(
        self,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ProjectRelation]]:
        """
        Return a list of all projects the current user has access to

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            "/projects",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[ProjectRelation])

    def update_project(
        self,
        project_id: int,
        project_update: Union[
            ProjectUpdate,
            ProjectUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing Project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._put(endpoint, project_update)

        return DevopnessResponse(response, None)


class ProjectsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    ProjectsApiServiceAsync - Auto Generated
    """

    async def add_organization_project(
        self,
        organization_id: str,
        project_organization_create: Union[
            ProjectOrganizationCreate,
            ProjectOrganizationCreatePlain,
        ],
    ) -> DevopnessResponse[Project]:
        """
        Create a project to a given organization

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/organizations/{organization_id}/projects",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, project_organization_create)

        return await DevopnessResponse.from_async(response, Project)

    async def add_project(
        self,
        project_create: Union[
            ProjectCreate,
            ProjectCreatePlain,
        ],
    ) -> DevopnessResponse[Project]:
        """
        Create a project for the authenticated user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/projects",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, project_create)

        return await DevopnessResponse.from_async(response, Project)

    async def get_project(
        self,
        project_id: int,
    ) -> DevopnessResponse[Project]:
        """
        Get a Project by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, Project)

    async def list_organization_projects(
        self,
        organization_id: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ProjectRelation]]:
        """
        List all projects belonging to an organization

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/organizations/{organization_id}/projects",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[ProjectRelation])

    async def list_projects(
        self,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ProjectRelation]]:
        """
        Return a list of all projects the current user has access to

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            "/projects",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[ProjectRelation])

    async def update_project(
        self,
        project_id: int,
        project_update: Union[
            ProjectUpdate,
            ProjectUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing Project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._put(endpoint, project_update)

        return await DevopnessResponse.from_async(response, None)
