"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    ApiToken,
    ApiTokenProjectCreate,
    ApiTokenProjectCreatePlain,
    ApiTokenProjectRotate,
    ApiTokenProjectRotatePlain,
    ApiTokenRelation,
    ApiTokenRotateResponse,
)
from ..utils import parse_query_string


class ProjectsAPITokensApiService(DevopnessBaseService):
    """
    ProjectsAPITokensApiService - Auto Generated
    """

    def add_project_api_token(
        self,
        project_id: int,
        api_token_project_create: Union[
            ApiTokenProjectCreate,
            ApiTokenProjectCreatePlain,
        ],
    ) -> DevopnessResponse[ApiToken]:
        """
        Create a new API token for specific project.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/tokens",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, api_token_project_create)

        return DevopnessResponse(response, ApiToken)

    def get_project_api_token(
        self,
        project_id: int,
        token_id: str,
    ) -> DevopnessResponse[ApiToken]:
        """
        Get details of a specific project API token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/tokens/{token_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, ApiToken)

    def list_project_api_tokens(
        self,
        project_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ApiTokenRelation]]:
        """
        List the API tokens of specific project.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/projects/{project_id}/tokens",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[ApiTokenRelation])

    def revoke_project_api_token(
        self,
        project_id: int,
        token_id: str,
    ) -> DevopnessResponse[None]:
        """
        Revoke a specific project API token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/tokens/{token_id}/revoke",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def rotate_project_api_token(
        self,
        project_id: int,
        token_id: str,
        api_token_project_rotate: Union[
            ApiTokenProjectRotate,
            ApiTokenProjectRotatePlain,
        ],
    ) -> DevopnessResponse[ApiTokenRotateResponse]:
        """
        Rotate a specific project API token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/tokens/{token_id}/rotate",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, api_token_project_rotate)

        return DevopnessResponse(response, ApiTokenRotateResponse)


class ProjectsAPITokensApiServiceAsync(DevopnessBaseServiceAsync):
    """
    ProjectsAPITokensApiServiceAsync - Auto Generated
    """

    async def add_project_api_token(
        self,
        project_id: int,
        api_token_project_create: Union[
            ApiTokenProjectCreate,
            ApiTokenProjectCreatePlain,
        ],
    ) -> DevopnessResponse[ApiToken]:
        """
        Create a new API token for specific project.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/tokens",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, api_token_project_create)

        return await DevopnessResponse.from_async(response, ApiToken)

    async def get_project_api_token(
        self,
        project_id: int,
        token_id: str,
    ) -> DevopnessResponse[ApiToken]:
        """
        Get details of a specific project API token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/tokens/{token_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, ApiToken)

    async def list_project_api_tokens(
        self,
        project_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ApiTokenRelation]]:
        """
        List the API tokens of specific project.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/projects/{project_id}/tokens",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[ApiTokenRelation])

    async def revoke_project_api_token(
        self,
        project_id: int,
        token_id: str,
    ) -> DevopnessResponse[None]:
        """
        Revoke a specific project API token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/tokens/{token_id}/revoke",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._delete(endpoint)

        return await DevopnessResponse.from_async(response, None)

    async def rotate_project_api_token(
        self,
        project_id: int,
        token_id: str,
        api_token_project_rotate: Union[
            ApiTokenProjectRotate,
            ApiTokenProjectRotatePlain,
        ],
    ) -> DevopnessResponse[ApiTokenRotateResponse]:
        """
        Rotate a specific project API token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/tokens/{token_id}/rotate",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, api_token_project_rotate)

        return await DevopnessResponse.from_async(response, ApiTokenRotateResponse)
