"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import Role, RoleProjectCreate, RoleProjectCreatePlain, RoleRelation
from ..utils import parse_query_string


class ProjectsRolesApiService(DevopnessBaseService):
    """
    ProjectsRolesApiService - Auto Generated
    """

    def add_project_role(
        self,
        project_id: int,
        role_project_create: Union[
            RoleProjectCreate,
            RoleProjectCreatePlain,
        ],
    ) -> DevopnessResponse[Role]:
        """
        Create a role to a given project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/roles",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, role_project_create)

        return DevopnessResponse(response, Role)

    def list_project_roles(
        self,
        project_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[RoleRelation]]:
        """
        List all roles from a project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/projects/{project_id}/roles",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[RoleRelation])


class ProjectsRolesApiServiceAsync(DevopnessBaseServiceAsync):
    """
    ProjectsRolesApiServiceAsync - Auto Generated
    """

    async def add_project_role(
        self,
        project_id: int,
        role_project_create: Union[
            RoleProjectCreate,
            RoleProjectCreatePlain,
        ],
    ) -> DevopnessResponse[Role]:
        """
        Create a role to a given project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/roles",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, role_project_create)

        return await DevopnessResponse.from_async(response, Role)

    async def list_project_roles(
        self,
        project_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[RoleRelation]]:
        """
        List all roles from a project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/projects/{project_id}/roles",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[RoleRelation])
