"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import ResourceEvent, ResourceEventRelation
from ..utils import parse_query_string


class ResourceEventsApiService(DevopnessBaseService):
    """
    ResourceEventsApiService - Auto Generated
    """

    def add_resource_event(
        self,
        resource_id: str,
        resource_type: str,
    ) -> DevopnessResponse[ResourceEvent]:
        """
        Process event for a resource

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/events/{resource_type}/{resource_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint)

        return DevopnessResponse(response, ResourceEvent)

    def list_resource_events_by_resource_type(
        self,
        resource_id: int,
        resource_type: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ResourceEventRelation]]:
        """
        List events of a resource type

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/events/{resource_type}/{resource_id}",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[ResourceEventRelation])


class ResourceEventsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    ResourceEventsApiServiceAsync - Auto Generated
    """

    async def add_resource_event(
        self,
        resource_id: str,
        resource_type: str,
    ) -> DevopnessResponse[ResourceEvent]:
        """
        Process event for a resource

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/events/{resource_type}/{resource_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint)

        return await DevopnessResponse.from_async(response, ResourceEvent)

    async def list_resource_events_by_resource_type(
        self,
        resource_id: int,
        resource_type: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ResourceEventRelation]]:
        """
        List events of a resource type

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/events/{resource_type}/{resource_id}",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[ResourceEventRelation])
