"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import Subnet


class SubnetsApiService(DevopnessBaseService):
    """
    SubnetsApiService - Auto Generated
    """

    def delete_subnet(
        self,
        subnet_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given subnet

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/subnets/{subnet_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def get_subnet(
        self,
        subnet_id: int,
    ) -> DevopnessResponse[Subnet]:
        """
        Get a subnet by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/subnets/{subnet_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, Subnet)


class SubnetsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    SubnetsApiServiceAsync - Auto Generated
    """

    async def delete_subnet(
        self,
        subnet_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given subnet

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/subnets/{subnet_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._delete(endpoint)

        return await DevopnessResponse.from_async(response, None)

    async def get_subnet(
        self,
        subnet_id: int,
    ) -> DevopnessResponse[Subnet]:
        """
        Get a subnet by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/subnets/{subnet_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, Subnet)
