"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import Optional

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..utils import parse_query_string


class TeamInvitationsApiService(DevopnessBaseService):
    """
    TeamInvitationsApiService - Auto Generated
    """

    def accept_team_invitation(
        self,
        team_invitation_id: str,
        token: Optional[str] = None,
    ) -> DevopnessResponse[None]:
        """
        Accept a team invitation

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "token": token,
            }
        )

        endpoint_parts = [
            f"/team-invitations/{team_invitation_id}/accept",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint)

        return DevopnessResponse(response, None)

    def delete_team_invitation(
        self,
        team_invitation_id: str,
    ) -> DevopnessResponse[None]:
        """
        Delete a pending team invitation

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/team-invitations/{team_invitation_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def reject_team_invitation(
        self,
        team_invitation_id: str,
    ) -> DevopnessResponse[None]:
        """
        Reject a pending private team invitation

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/team-invitations/{team_invitation_id}/reject",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint)

        return DevopnessResponse(response, None)


class TeamInvitationsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    TeamInvitationsApiServiceAsync - Auto Generated
    """

    async def accept_team_invitation(
        self,
        team_invitation_id: str,
        token: Optional[str] = None,
    ) -> DevopnessResponse[None]:
        """
        Accept a team invitation

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "token": token,
            }
        )

        endpoint_parts = [
            f"/team-invitations/{team_invitation_id}/accept",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint)

        return await DevopnessResponse.from_async(response, None)

    async def delete_team_invitation(
        self,
        team_invitation_id: str,
    ) -> DevopnessResponse[None]:
        """
        Delete a pending team invitation

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/team-invitations/{team_invitation_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._delete(endpoint)

        return await DevopnessResponse.from_async(response, None)

    async def reject_team_invitation(
        self,
        team_invitation_id: str,
    ) -> DevopnessResponse[None]:
        """
        Reject a pending private team invitation

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/team-invitations/{team_invitation_id}/reject",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint)

        return await DevopnessResponse.from_async(response, None)
