"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import Team, TeamUpdate, TeamUpdatePlain


class TeamsApiService(DevopnessBaseService):
    """
    TeamsApiService - Auto Generated
    """

    def delete_team(
        self,
        team_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def get_team(
        self,
        team_id: int,
    ) -> DevopnessResponse[Team]:
        """
        Get a team by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, Team)

    def update_team(
        self,
        team_id: int,
        team_update: Union[
            TeamUpdate,
            TeamUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._put(endpoint, team_update)

        return DevopnessResponse(response, None)


class TeamsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    TeamsApiServiceAsync - Auto Generated
    """

    async def delete_team(
        self,
        team_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._delete(endpoint)

        return await DevopnessResponse.from_async(response, None)

    async def get_team(
        self,
        team_id: int,
    ) -> DevopnessResponse[Team]:
        """
        Get a team by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, Team)

    async def update_team(
        self,
        team_id: int,
        team_update: Union[
            TeamUpdate,
            TeamUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._put(endpoint, team_update)

        return await DevopnessResponse.from_async(response, None)
