"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Invitation,
    InvitationRelation,
    InvitationTeamCreate,
    InvitationTeamCreatePlain,
)
from ..utils import parse_query_string


class TeamsInvitationsApiService(DevopnessBaseService):
    """
    TeamsInvitationsApiService - Auto Generated
    """

    def add_team_invitation(
        self,
        team_id: int,
        invitation_team_create: Union[
            InvitationTeamCreate,
            InvitationTeamCreatePlain,
        ],
    ) -> DevopnessResponse[Invitation]:
        """
        Create a new invitation for a team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}/invitations",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, invitation_team_create)

        return DevopnessResponse(response, Invitation)

    def list_team_invitations(
        self,
        team_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[InvitationRelation]]:
        """
        Return a list of invitations belonging to a team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/teams/{team_id}/invitations",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[InvitationRelation])


class TeamsInvitationsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    TeamsInvitationsApiServiceAsync - Auto Generated
    """

    async def add_team_invitation(
        self,
        team_id: int,
        invitation_team_create: Union[
            InvitationTeamCreate,
            InvitationTeamCreatePlain,
        ],
    ) -> DevopnessResponse[Invitation]:
        """
        Create a new invitation for a team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}/invitations",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, invitation_team_create)

        return await DevopnessResponse.from_async(response, Invitation)

    async def list_team_invitations(
        self,
        team_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[InvitationRelation]]:
        """
        Return a list of invitations belonging to a team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/teams/{team_id}/invitations",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[InvitationRelation])
