"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import MembershipRelation
from ..utils import parse_query_string


class TeamsMembershipsApiService(DevopnessBaseService):
    """
    TeamsMembershipsApiService - Auto Generated
    """

    def list_team_memberships(
        self,
        team_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[MembershipRelation]]:
        """
        Return a list of all memberships of a team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/teams/{team_id}/memberships",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[MembershipRelation])


class TeamsMembershipsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    TeamsMembershipsApiServiceAsync - Auto Generated
    """

    async def list_team_memberships(
        self,
        team_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[MembershipRelation]]:
        """
        Return a list of all memberships of a team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/teams/{team_id}/memberships",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[MembershipRelation])
