"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

import warnings
from typing import Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    User,
    UserActivity,
    UserBilling,
    UserLoginResponse,
    UserMe,
    UserRefreshToken,
    UserRefreshTokenPlain,
    UserRefreshTokenResponse,
    UserResendVerification,
    UserResendVerificationPlain,
    UserUrl,
)


class UsersApiService(DevopnessBaseService):
    """
    UsersApiService - Auto Generated
    """

    def add_user(
        self,
    ) -> DevopnessResponse[None]:
        """
        Sign up/register a new user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`add_user` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint)

        return DevopnessResponse(response, None)

    def get_user(
        self,
        user_id: str,
    ) -> DevopnessResponse[User]:
        """
        Get a user by ID or URL Slug

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/users/{user_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, User)

    def get_user_activity(
        self,
        user_id: str,
    ) -> DevopnessResponse[UserActivity]:
        """
        Get activity information for a user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/users/{user_id}/activity",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, UserActivity)

    def get_user_billing(
        self,
    ) -> DevopnessResponse[UserBilling]:
        """
        Get current user's billing info for active subscription

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/users/billing",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, UserBilling)

    def get_user_logout(
        self,
    ) -> DevopnessResponse[None]:
        """
        Logout/revoke an existing token

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`get_user_logout` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/logout",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, None)

    def get_user_me(
        self,
    ) -> DevopnessResponse[UserMe]:
        """
        Get details of the current user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/users/me",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, UserMe)

    def get_user_urls(
        self,
    ) -> DevopnessResponse[UserUrl]:
        """
        Get the authenticated user's URLs

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/users/urls",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, UserUrl)

    def login_user(
        self,
    ) -> DevopnessResponse[UserLoginResponse]:
        """
        Login/create a new token for the given credentials

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`login_user` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/login",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint)

        return DevopnessResponse(response, UserLoginResponse)

    def refresh_token_user(
        self,
        user_refresh_token: Union[
            UserRefreshToken,
            UserRefreshTokenPlain,
        ],
    ) -> DevopnessResponse[UserRefreshTokenResponse]:
        """
        Refresh an existing user access token

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`refresh_token_user` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/refresh-token",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, user_refresh_token)

        return DevopnessResponse(response, UserRefreshTokenResponse)

    def resend_verification_user(
        self,
        user_resend_verification: Union[
            UserResendVerification,
            UserResendVerificationPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Resend the verification email

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/users/account/resend-verification",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, user_resend_verification)

        return DevopnessResponse(response, None)

    def update_user(
        self,
        user_id: str,
    ) -> DevopnessResponse[None]:
        """
        Update an existing user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`update_user` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            f"/users/{user_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._put(endpoint)

        return DevopnessResponse(response, None)

    def verify_user(
        self,
    ) -> DevopnessResponse[None]:
        """
        Activate the user account

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`verify_user` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/account/verify",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint)

        return DevopnessResponse(response, None)


class UsersApiServiceAsync(DevopnessBaseServiceAsync):
    """
    UsersApiServiceAsync - Auto Generated
    """

    async def add_user(
        self,
    ) -> DevopnessResponse[None]:
        """
        Sign up/register a new user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`add_user` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint)

        return await DevopnessResponse.from_async(response, None)

    async def get_user(
        self,
        user_id: str,
    ) -> DevopnessResponse[User]:
        """
        Get a user by ID or URL Slug

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/users/{user_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, User)

    async def get_user_activity(
        self,
        user_id: str,
    ) -> DevopnessResponse[UserActivity]:
        """
        Get activity information for a user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/users/{user_id}/activity",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, UserActivity)

    async def get_user_billing(
        self,
    ) -> DevopnessResponse[UserBilling]:
        """
        Get current user's billing info for active subscription

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/users/billing",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, UserBilling)

    async def get_user_logout(
        self,
    ) -> DevopnessResponse[None]:
        """
        Logout/revoke an existing token

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`get_user_logout` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/logout",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, None)

    async def get_user_me(
        self,
    ) -> DevopnessResponse[UserMe]:
        """
        Get details of the current user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/users/me",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, UserMe)

    async def get_user_urls(
        self,
    ) -> DevopnessResponse[UserUrl]:
        """
        Get the authenticated user's URLs

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/users/urls",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, UserUrl)

    async def login_user(
        self,
    ) -> DevopnessResponse[UserLoginResponse]:
        """
        Login/create a new token for the given credentials

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`login_user` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/login",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint)

        return await DevopnessResponse.from_async(response, UserLoginResponse)

    async def refresh_token_user(
        self,
        user_refresh_token: Union[
            UserRefreshToken,
            UserRefreshTokenPlain,
        ],
    ) -> DevopnessResponse[UserRefreshTokenResponse]:
        """
        Refresh an existing user access token

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`refresh_token_user` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/refresh-token",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, user_refresh_token)

        return await DevopnessResponse.from_async(response, UserRefreshTokenResponse)

    async def resend_verification_user(
        self,
        user_resend_verification: Union[
            UserResendVerification,
            UserResendVerificationPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Resend the verification email

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/users/account/resend-verification",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, user_resend_verification)

        return await DevopnessResponse.from_async(response, None)

    async def update_user(
        self,
        user_id: str,
    ) -> DevopnessResponse[None]:
        """
        Update an existing user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`update_user` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            f"/users/{user_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._put(endpoint)

        return await DevopnessResponse.from_async(response, None)

    async def verify_user(
        self,
    ) -> DevopnessResponse[None]:
        """
        Activate the user account

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`verify_user` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/account/verify",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint)

        return await DevopnessResponse.from_async(response, None)
