"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

import warnings
from typing import Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import PasswordResetResponse, PasswordUserReset, PasswordUserResetPlain


class UsersPasswordsApiService(DevopnessBaseService):
    """
    UsersPasswordsApiService - Auto Generated
    """

    def reset_user_password(
        self,
        password_user_reset: Union[
            PasswordUserReset,
            PasswordUserResetPlain,
        ],
    ) -> DevopnessResponse[PasswordResetResponse]:
        """
        Reset the user password

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`reset_user_password` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/password/reset",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, password_user_reset)

        return DevopnessResponse(response, PasswordResetResponse)

    def send_reset_link_user_password(
        self,
    ) -> DevopnessResponse[None]:
        """
        Send the password reset link to user's email

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`send_reset_link_user_password` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/password/send-reset-link",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint)

        return DevopnessResponse(response, None)


class UsersPasswordsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    UsersPasswordsApiServiceAsync - Auto Generated
    """

    async def reset_user_password(
        self,
        password_user_reset: Union[
            PasswordUserReset,
            PasswordUserResetPlain,
        ],
    ) -> DevopnessResponse[PasswordResetResponse]:
        """
        Reset the user password

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`reset_user_password` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/password/reset",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, password_user_reset)

        return await DevopnessResponse.from_async(response, PasswordResetResponse)

    async def send_reset_link_user_password(
        self,
    ) -> DevopnessResponse[None]:
        """
        Send the password reset link to user's email

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.

        ## Deprecated
            This method is deprecated and may be removed in future releases.
        """
        warnings.warn(
            "`send_reset_link_user_password` is deprecated and may be removed in future releases.",
            DeprecationWarning,
            stacklevel=2,
        )

        endpoint_parts = [
            "/users/password/send-reset-link",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint)

        return await DevopnessResponse.from_async(response, None)
