"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    PersonalAccessToken,
    PersonalAccessTokenRelation,
    PersonalAccessTokenRotateResponse,
    PersonalAccessTokenUserCreate,
    PersonalAccessTokenUserCreatePlain,
    PersonalAccessTokenUserRotate,
    PersonalAccessTokenUserRotatePlain,
)
from ..utils import parse_query_string


class UsersPersonalAccessTokensApiService(DevopnessBaseService):
    """
    UsersPersonalAccessTokensApiService - Auto Generated
    """

    def add_user_personal_access_token(
        self,
        personal_access_token_user_create: Union[
            PersonalAccessTokenUserCreate,
            PersonalAccessTokenUserCreatePlain,
        ],
    ) -> DevopnessResponse[PersonalAccessToken]:
        """
        Create a new personal access token for the authenticated user.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/users/personal-access-tokens",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, personal_access_token_user_create)

        return DevopnessResponse(response, PersonalAccessToken)

    def get_user_personal_access_token(
        self,
        personal_access_token_id: str,
    ) -> DevopnessResponse[PersonalAccessToken]:
        """
        Get details of a specific personal access token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/users/personal-access-tokens/{personal_access_token_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, PersonalAccessToken)

    def list_user_personal_access_tokens(
        self,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[PersonalAccessTokenRelation]]:
        """
        List the personal access tokens of authenticated user.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            "/users/personal-access-tokens",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[PersonalAccessTokenRelation])

    def revoke_user_personal_access_token(
        self,
        personal_access_token_id: str,
    ) -> DevopnessResponse[None]:
        """
        Revoke a specific personal access token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/users/personal-access-tokens/{personal_access_token_id}/revoke",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def rotate_user_personal_access_token(
        self,
        personal_access_token_id: str,
        personal_access_token_user_rotate: Union[
            PersonalAccessTokenUserRotate,
            PersonalAccessTokenUserRotatePlain,
        ],
    ) -> DevopnessResponse[PersonalAccessTokenRotateResponse]:
        """
        Rotate a specific personal access token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/users/personal-access-tokens/{personal_access_token_id}/rotate",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._post(endpoint, personal_access_token_user_rotate)

        return DevopnessResponse(response, PersonalAccessTokenRotateResponse)


class UsersPersonalAccessTokensApiServiceAsync(DevopnessBaseServiceAsync):
    """
    UsersPersonalAccessTokensApiServiceAsync - Auto Generated
    """

    async def add_user_personal_access_token(
        self,
        personal_access_token_user_create: Union[
            PersonalAccessTokenUserCreate,
            PersonalAccessTokenUserCreatePlain,
        ],
    ) -> DevopnessResponse[PersonalAccessToken]:
        """
        Create a new personal access token for the authenticated user.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/users/personal-access-tokens",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, personal_access_token_user_create)

        return await DevopnessResponse.from_async(response, PersonalAccessToken)

    async def get_user_personal_access_token(
        self,
        personal_access_token_id: str,
    ) -> DevopnessResponse[PersonalAccessToken]:
        """
        Get details of a specific personal access token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/users/personal-access-tokens/{personal_access_token_id}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, PersonalAccessToken)

    async def list_user_personal_access_tokens(
        self,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[PersonalAccessTokenRelation]]:
        """
        List the personal access tokens of authenticated user.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            "/users/personal-access-tokens",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(
            response, List[PersonalAccessTokenRelation]
        )

    async def revoke_user_personal_access_token(
        self,
        personal_access_token_id: str,
    ) -> DevopnessResponse[None]:
        """
        Revoke a specific personal access token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/users/personal-access-tokens/{personal_access_token_id}/revoke",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._delete(endpoint)

        return await DevopnessResponse.from_async(response, None)

    async def rotate_user_personal_access_token(
        self,
        personal_access_token_id: str,
        personal_access_token_user_rotate: Union[
            PersonalAccessTokenUserRotate,
            PersonalAccessTokenUserRotatePlain,
        ],
    ) -> DevopnessResponse[PersonalAccessTokenRotateResponse]:
        """
        Rotate a specific personal access token.

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/users/personal-access-tokens/{personal_access_token_id}/rotate",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._post(endpoint, personal_access_token_user_rotate)

        return await DevopnessResponse.from_async(
            response, PersonalAccessTokenRotateResponse
        )
