"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import ProjectRelation
from ..utils import parse_query_string


class UsersProjectsApiService(DevopnessBaseService):
    """
    UsersProjectsApiService - Auto Generated
    """

    def list_user_projects(
        self,
        user_id: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
        subscription_id: Optional[int] = None,
    ) -> DevopnessResponse[List[ProjectRelation]]:
        """
        Return a list of all projects owned by a user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
                "subscription_id": subscription_id,
            }
        )

        endpoint_parts = [
            f"/users/{user_id}/projects",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = self._get(endpoint)

        return DevopnessResponse(response, List[ProjectRelation])


class UsersProjectsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    UsersProjectsApiServiceAsync - Auto Generated
    """

    async def list_user_projects(
        self,
        user_id: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
        subscription_id: Optional[int] = None,
    ) -> DevopnessResponse[List[ProjectRelation]]:
        """
        Return a list of all projects owned by a user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
                "subscription_id": subscription_id,
            }
        )

        endpoint_parts = [
            f"/users/{user_id}/projects",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)
        response = await self._get(endpoint)

        return await DevopnessResponse.from_async(response, List[ProjectRelation])
