"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_deployment_data import ActionDeploymentData, ActionDeploymentDataPlain
from .action_hook_request import ActionHookRequest, ActionHookRequestPlain
from .action_resource import ActionResource, ActionResourcePlain
from .action_status import ActionStatus, ActionStatusPlain
from .action_status_reason_code import (
    ActionStatusReasonCode,
    ActionStatusReasonCodePlain,
)
from .action_summary import ActionSummary, ActionSummaryPlain
from .action_target import ActionTarget, ActionTargetPlain
from .action_triggered_from import ActionTriggeredFrom, ActionTriggeredFromPlain
from .action_type import ActionType, ActionTypePlain
from .environment_relation import EnvironmentRelation, EnvironmentRelationPlain
from .project_relation import ProjectRelation, ProjectRelationPlain
from .related_action import RelatedAction, RelatedActionPlain
from .user_relation import UserRelation, UserRelationPlain


class Action(DevopnessBaseModel):
    """
    Action

    Attributes:
        id (int): The Id of the given action
        pipeline_id (int, optional, nullable): The ID of the pipeline executed by this action
        retry_of (int, optional, nullable): The Id of the parent action that this action is a retry of
        status (ActionStatus):
        status_human_readable (str): Human readable version of action status
        status_reason_code (ActionStatusReasonCode):
        status_reason_human_readable (str): Human readable version of the status reason code
        type (ActionType):
        type_human_readable (str): Human readable version of the action type
        url_web_permalink (str): The permalink URL to the action details on Devopness web app
        action_data (ActionDeploymentData, optional, nullable):
        triggered_from (ActionTriggeredFrom):
        parent (RelatedAction, optional, nullable):
        children (List[RelatedAction]): List of related actions
        triggered_by_user (UserRelation, optional):
        resource (ActionResource):
        summary (ActionSummary):
        environment (EnvironmentRelation, optional, nullable):
        project (ProjectRelation, optional, nullable):
        targets (List[ActionTarget], optional): List of actions dispatched to cloud resource targets
        hook_requests (ActionHookRequest, optional):
        started_at (str, optional, nullable): The date and time when the action started execution (i.e., left the &#x60;pending/queued&#x60; status)
        completed_at (str, optional, nullable): The date and time when the action has finished execution
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The Id of the given action")
    pipeline_id: Optional[StrictInt] = Field(
        description="The ID of the pipeline executed by this action"
    )
    retry_of: Optional[StrictInt] = Field(
        description="The Id of the parent action that this action is a retry of"
    )
    status: ActionStatus
    status_human_readable: StrictStr = Field(
        description="Human readable version of action status"
    )
    status_reason_code: ActionStatusReasonCode
    status_reason_human_readable: StrictStr = Field(
        description="Human readable version of the status reason code"
    )
    type: ActionType
    type_human_readable: StrictStr = Field(
        description="Human readable version of the action type"
    )
    url_web_permalink: StrictStr = Field(
        description="The permalink URL to the action details on Devopness web app"
    )
    action_data: Optional[ActionDeploymentData]
    triggered_from: ActionTriggeredFrom
    parent: Optional[RelatedAction]
    children: List[Optional[RelatedAction]] = Field(
        description="List of related actions"
    )
    triggered_by_user: Optional[UserRelation] = None
    resource: ActionResource
    summary: ActionSummary
    environment: Optional[EnvironmentRelation]
    project: Optional[ProjectRelation]
    targets: Optional[List[ActionTarget]] = Field(
        default=None, description="List of actions dispatched to cloud resource targets"
    )
    hook_requests: Optional[ActionHookRequest] = None
    started_at: Optional[StrictStr] = Field(
        description="The date and time when the action started execution (i.e., left the `pending/queued` status)"
    )
    completed_at: Optional[StrictStr] = Field(
        description="The date and time when the action has finished execution"
    )
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class ActionPlain(TypedDict, total=False):
    """
    Plain version of Action.
    """

    id: Required[int]
    pipeline_id: Optional[int]
    retry_of: Optional[int]
    status: Required[
        Union[
            ActionStatus,
            ActionStatusPlain,
        ]
    ]
    status_human_readable: Required[str]
    status_reason_code: Required[
        Union[
            ActionStatusReasonCode,
            ActionStatusReasonCodePlain,
        ]
    ]
    status_reason_human_readable: Required[str]
    type: Required[
        Union[
            ActionType,
            ActionTypePlain,
        ]
    ]
    type_human_readable: Required[str]
    url_web_permalink: Required[str]
    action_data: Optional[
        Union[
            ActionDeploymentData,
            ActionDeploymentDataPlain,
        ]
    ]
    triggered_from: Required[
        Union[
            ActionTriggeredFrom,
            ActionTriggeredFromPlain,
        ]
    ]
    parent: Optional[
        Union[
            RelatedAction,
            RelatedActionPlain,
        ]
    ]
    children: Required[
        List[
            Union[
                RelatedAction,
                RelatedActionPlain,
            ]
        ]
    ]
    triggered_by_user: Optional[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    resource: Required[
        Union[
            ActionResource,
            ActionResourcePlain,
        ]
    ]
    summary: Required[
        Union[
            ActionSummary,
            ActionSummaryPlain,
        ]
    ]
    environment: Optional[
        Union[
            EnvironmentRelation,
            EnvironmentRelationPlain,
        ]
    ]
    project: Optional[
        Union[
            ProjectRelation,
            ProjectRelationPlain,
        ]
    ]
    targets: Optional[
        List[
            Union[
                ActionTarget,
                ActionTargetPlain,
            ]
        ]
    ]
    hook_requests: Optional[
        Union[
            ActionHookRequest,
            ActionHookRequestPlain,
        ]
    ]
    started_at: Optional[str]
    completed_at: Optional[str]
    created_at: Required[str]
    updated_at: Required[str]
