"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .deployment_type import DeploymentType, DeploymentTypePlain
from .source_type import SourceType, SourceTypePlain


class ActionDeploymentContent(DevopnessBaseModel):
    """
    ActionDeploymentContent

    Attributes:
        type (DeploymentType):
        source_type (SourceType):
        source_ref (str): A git reference pointing to a commit in a source provider repository from which the application source code will be retrieved and deployed. It can be a branch name, tag name or a specific commit hash.
        repository (str): The repository of the deployed application
        provider_name (str): The source provider&#39;s name
        pipeline_id (int): The ID of the pipeline
    """

    type: DeploymentType
    source_type: SourceType
    source_ref: StrictStr = Field(
        description="A git reference pointing to a commit in a source provider repository from which the application source code will be retrieved and deployed. It can be a branch name, tag name or a specific commit hash."
    )
    repository: StrictStr = Field(
        description="The repository of the deployed application"
    )
    provider_name: StrictStr = Field(description="The source provider's name")
    pipeline_id: StrictInt = Field(description="The ID of the pipeline")


class ActionDeploymentContentPlain(TypedDict, total=False):
    """
    Plain version of ActionDeploymentContent.
    """

    type: Required[
        Union[
            DeploymentType,
            DeploymentTypePlain,
        ]
    ]
    source_type: Required[
        Union[
            SourceType,
            SourceTypePlain,
        ]
    ]
    source_ref: Required[str]
    repository: Required[str]
    provider_name: Required[str]
    pipeline_id: Required[int]
