"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from datetime import datetime
from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_deployment_data import ActionDeploymentData, ActionDeploymentDataPlain
from .action_status import ActionStatus, ActionStatusPlain
from .action_status_reason_code import (
    ActionStatusReasonCode,
    ActionStatusReasonCodePlain,
)
from .action_summary import ActionSummary, ActionSummaryPlain
from .action_target import ActionTarget, ActionTargetPlain
from .action_triggered_from import ActionTriggeredFrom, ActionTriggeredFromPlain
from .action_type import ActionType, ActionTypePlain


class ActionRelationShallow(DevopnessBaseModel):
    """
    ActionRelationShallow

    Attributes:
        id (int): The Id of the action
        status (ActionStatus):
        status_human_readable (str): Human readable version of the action status
        status_reason_code (ActionStatusReasonCode):
        status_reason_human_readable (str): Human readable version of the status reason code
        type (ActionType):
        type_human_readable (str): Human readable version of the action type
        url_web_permalink (str): Permalink to view the action on Devopness web
        action_data (ActionDeploymentData, optional, nullable):
        triggered_from (ActionTriggeredFrom, optional):
        summary (ActionSummary, optional):
        targets (List[ActionTarget], optional): List of actions dispatched to cloud resource targets
        started_at (datetime, optional, nullable): When the action started
        completed_at (datetime, optional, nullable): When the action completed
        created_at (datetime): When the action was created
        updated_at (datetime): When the action was last updated
    """

    id: StrictInt = Field(description="The Id of the action")
    status: ActionStatus
    status_human_readable: StrictStr = Field(
        description="Human readable version of the action status"
    )
    status_reason_code: ActionStatusReasonCode
    status_reason_human_readable: StrictStr = Field(
        description="Human readable version of the status reason code"
    )
    type: ActionType
    type_human_readable: StrictStr = Field(
        description="Human readable version of the action type"
    )
    url_web_permalink: StrictStr = Field(
        description="Permalink to view the action on Devopness web"
    )
    action_data: Optional[ActionDeploymentData] = None
    triggered_from: Optional[ActionTriggeredFrom] = None
    summary: Optional[ActionSummary] = None
    targets: Optional[List[ActionTarget]] = Field(
        default=None, description="List of actions dispatched to cloud resource targets"
    )
    started_at: Optional[datetime] = Field(description="When the action started")
    completed_at: Optional[datetime] = Field(description="When the action completed")
    created_at: datetime = Field(description="When the action was created")
    updated_at: datetime = Field(description="When the action was last updated")


class ActionRelationShallowPlain(TypedDict, total=False):
    """
    Plain version of ActionRelationShallow.
    """

    id: Required[int]
    status: Required[
        Union[
            ActionStatus,
            ActionStatusPlain,
        ]
    ]
    status_human_readable: Required[str]
    status_reason_code: Required[
        Union[
            ActionStatusReasonCode,
            ActionStatusReasonCodePlain,
        ]
    ]
    status_reason_human_readable: Required[str]
    type: Required[
        Union[
            ActionType,
            ActionTypePlain,
        ]
    ]
    type_human_readable: Required[str]
    url_web_permalink: Required[str]
    action_data: Optional[
        Union[
            ActionDeploymentData,
            ActionDeploymentDataPlain,
        ]
    ]
    triggered_from: Optional[
        Union[
            ActionTriggeredFrom,
            ActionTriggeredFromPlain,
        ]
    ]
    summary: Optional[
        Union[
            ActionSummary,
            ActionSummaryPlain,
        ]
    ]
    targets: Optional[
        List[
            Union[
                ActionTarget,
                ActionTargetPlain,
            ]
        ]
    ]
    started_at: Optional[datetime]
    completed_at: Optional[datetime]
    created_at: Required[datetime]
    updated_at: Required[datetime]
