"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from datetime import datetime
from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_status import ActionStatus, ActionStatusPlain
from .action_status_reason_code import (
    ActionStatusReasonCode,
    ActionStatusReasonCodePlain,
)


class ActionStep(DevopnessBaseModel):
    """
    ActionStep

    Attributes:
        id (int): The unique id of the action step
        action_id (int): The unique id of the action linked to this step
        action_target_id (int): The unique id of the action target linked to this step
        name (str, optional, nullable): Name of the action describing your purpose
        description (str, optional, nullable): A short text describing the command. Can be helpful for other team members to understand why a pipeline step is needed.
        order (int): The execution order of the given step
        status (ActionStatus):
        status_human_readable (str, optional): Human readable version of the action status
        status_reason_code (ActionStatusReasonCode, optional):
        status_reason_human_readable (str, optional): Human readable version of the status reason code
        started_at (datetime, optional, nullable): The date and time when the action started execution (i.e., left the &#x60;pending/queued&#x60; status)
        completed_at (datetime, optional, nullable): The date and time when the action has finished execution
        created_at (datetime, optional): The date and time when the record was created
        updated_at (datetime, optional): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique id of the action step")
    action_id: StrictInt = Field(
        description="The unique id of the action linked to this step"
    )
    action_target_id: StrictInt = Field(
        description="The unique id of the action target linked to this step"
    )
    name: Optional[StrictStr] = Field(
        description="Name of the action describing your purpose"
    )
    description: Optional[StrictStr] = Field(
        default=None,
        description="A short text describing the command. Can be helpful for other team members to understand why a pipeline step is needed.",
    )
    order: StrictInt = Field(description="The execution order of the given step")
    status: ActionStatus
    status_human_readable: Optional[StrictStr] = Field(
        default=None, description="Human readable version of the action status"
    )
    status_reason_code: Optional[ActionStatusReasonCode] = None
    status_reason_human_readable: Optional[StrictStr] = Field(
        default=None, description="Human readable version of the status reason code"
    )
    started_at: Optional[datetime] = Field(
        default=None,
        description="The date and time when the action started execution (i.e., left the `pending/queued` status)",
    )
    completed_at: Optional[datetime] = Field(
        default=None,
        description="The date and time when the action has finished execution",
    )
    created_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was last updated"
    )


class ActionStepPlain(TypedDict, total=False):
    """
    Plain version of ActionStep.
    """

    id: Required[int]
    action_id: Required[int]
    action_target_id: Required[int]
    name: Optional[str]
    description: Optional[str]
    order: Required[int]
    status: Required[
        Union[
            ActionStatus,
            ActionStatusPlain,
        ]
    ]
    status_human_readable: Optional[str]
    status_reason_code: Optional[
        Union[
            ActionStatusReasonCode,
            ActionStatusReasonCodePlain,
        ]
    ]
    status_reason_human_readable: Optional[str]
    started_at: Optional[datetime]
    completed_at: Optional[datetime]
    created_at: Optional[datetime]
    updated_at: Optional[datetime]
