"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .network_provision_input import NetworkProvisionInput, NetworkProvisionInputPlain


class ActionTargetNetworkData(DevopnessBaseModel):
    """
    ActionTargetNetworkData

    Attributes:
        id (int): The unique id of the network
        name (str): The networks&#39;s name
        provider_name (str, optional): The name of the network&#39;s cloud provider.
        provider_name_human_readable (str, optional): The human readable version of the cloud provider&#39;s name
        provision_input (NetworkProvisionInput):
    """

    id: StrictInt = Field(description="The unique id of the network")
    name: StrictStr = Field(description="The networks's name")
    provider_name: Optional[StrictStr] = Field(
        default=None, description="The name of the network's cloud provider."
    )
    provider_name_human_readable: Optional[StrictStr] = Field(
        default=None,
        description="The human readable version of the cloud provider's name",
    )
    provision_input: NetworkProvisionInput


class ActionTargetNetworkDataPlain(TypedDict, total=False):
    """
    Plain version of ActionTargetNetworkData.
    """

    id: Required[int]
    name: Required[str]
    provider_name: Optional[str]
    provider_name_human_readable: Optional[str]
    provision_input: Required[
        Union[
            NetworkProvisionInput,
            NetworkProvisionInputPlain,
        ]
    ]
