"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .api_token_status import ApiTokenStatus, ApiTokenStatusPlain
from .api_token_type import ApiTokenType, ApiTokenTypePlain
from .role_relation import RoleRelation, RoleRelationPlain


class ApiTokenRelation(DevopnessBaseModel):
    """
    ApiTokenRelation

    Attributes:
        id (str): Unique identifier of the Token
        name (str): Name of the Token
        type (ApiTokenType):
        status (ApiTokenStatus):
        role (RoleRelation, optional, nullable):
        last_used_at (str, optional, nullable): Last time the Token was used
        expires_at (str): Expiration date of the Token
        revoked_at (str, optional, nullable): Revocation date of the Token
        updated_at (str): Last time the Token was updated
        created_at (str): Creation date of the Token
    """

    id: StrictStr = Field(description="Unique identifier of the Token")
    name: StrictStr = Field(description="Name of the Token")
    type: ApiTokenType
    status: ApiTokenStatus
    role: Optional[RoleRelation]
    last_used_at: Optional[StrictStr] = Field(
        description="Last time the Token was used"
    )
    expires_at: StrictStr = Field(description="Expiration date of the Token")
    revoked_at: Optional[StrictStr] = Field(description="Revocation date of the Token")
    updated_at: StrictStr = Field(description="Last time the Token was updated")
    created_at: StrictStr = Field(description="Creation date of the Token")


class ApiTokenRelationPlain(TypedDict, total=False):
    """
    Plain version of ApiTokenRelation.
    """

    id: Required[str]
    name: Required[str]
    type: Required[
        Union[
            ApiTokenType,
            ApiTokenTypePlain,
        ]
    ]
    status: Required[
        Union[
            ApiTokenStatus,
            ApiTokenStatusPlain,
        ]
    ]
    role: Optional[
        Union[
            RoleRelation,
            RoleRelationPlain,
        ]
    ]
    last_used_at: Optional[str]
    expires_at: Required[str]
    revoked_at: Optional[str]
    updated_at: Required[str]
    created_at: Required[str]
