"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .billing_plan import BillingPlan, BillingPlanPlain


class BillingPlansOptionsRelation(DevopnessBaseModel):
    """
    BillingPlansOptionsRelation

    Attributes:
        name (str): Product name of the plan
        hint (str, optional, nullable): A short text describing the target audience of the product
        plans (List[BillingPlan]): The list of plans available for billing
    """

    name: StrictStr = Field(description="Product name of the plan")
    hint: Optional[StrictStr] = Field(
        description="A short text describing the target audience of the product"
    )
    plans: List[BillingPlan] = Field(
        description="The list of plans available for billing"
    )


class BillingPlansOptionsRelationPlain(TypedDict, total=False):
    """
    Plain version of BillingPlansOptionsRelation.
    """

    name: Required[str]
    hint: Optional[str]
    plans: Required[
        List[
            Union[
                BillingPlan,
                BillingPlanPlain,
            ]
        ]
    ]
