"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictStr

from .. import DevopnessBaseModel
from .service_initial_state import ServiceInitialState, ServiceInitialStatePlain
from .service_type import ServiceType, ServiceTypePlain


class BlueprintService(DevopnessBaseModel):
    """
    BlueprintService

    Attributes:
        auto_start (bool, optional): Indicates if the service will start automatically on operating system boot
        initial_state (ServiceInitialState, optional):
        type (ServiceType):
        version (str): The service version
    """

    auto_start: Optional[StrictBool] = Field(
        default=None,
        description="Indicates if the service will start automatically on operating system boot",
    )
    initial_state: Optional[ServiceInitialState] = ServiceInitialState.STARTED
    type: ServiceType
    version: StrictStr = Field(description="The service version")


class BlueprintServicePlain(TypedDict, total=False):
    """
    Plain version of BlueprintService.
    """

    auto_start: Optional[bool]
    initial_state: Optional[
        Union[
            ServiceInitialState,
            ServiceInitialStatePlain,
        ]
    ]
    type: Required[
        Union[
            ServiceType,
            ServiceTypePlain,
        ]
    ]
    version: Required[str]
