"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .cloud_provider_service import CloudProviderService, CloudProviderServicePlain
from .cloud_provider_settings_list import (
    CloudProviderSettingsList,
    CloudProviderSettingsListPlain,
)


class CloudProvider(DevopnessBaseModel):
    """
    CloudProvider

    Attributes:
        code (str): Cloud provider code
        name (str): Cloud provider name
        hint (str, optional): Descriptive text to help users to know what data is stored in the field and optional extra information on how to enter data to the field
        logo_url (str): The provider&#39;s logo URL.
        cloud_services (List[CloudProviderService], optional):
        settings (CloudProviderSettingsList, optional):
    """

    code: StrictStr = Field(description="Cloud provider code")
    name: StrictStr = Field(description="Cloud provider name")
    hint: Optional[StrictStr] = Field(
        default=None,
        description="Descriptive text to help users to know what data is stored in the field and optional extra information on how to enter data to the field",
    )
    logo_url: StrictStr = Field(description="The provider's logo URL.")
    cloud_services: Optional[List[CloudProviderService]] = None
    settings: Optional[CloudProviderSettingsList] = None


class CloudProviderPlain(TypedDict, total=False):
    """
    Plain version of CloudProvider.
    """

    code: Required[str]
    name: Required[str]
    hint: Optional[str]
    logo_url: Required[str]
    cloud_services: Optional[
        List[
            Union[
                CloudProviderService,
                CloudProviderServicePlain,
            ]
        ]
    ]
    settings: Optional[
        Union[
            CloudProviderSettingsList,
            CloudProviderSettingsListPlain,
        ]
    ]
