"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .cloud_provider_property_type import (
    CloudProviderPropertyType,
    CloudProviderPropertyTypePlain,
)


class CloudProviderPropertyValidation(DevopnessBaseModel):
    """
    CloudProviderPropertyValidation

    Attributes:
        required (bool): Defines if the property is required
        type (CloudProviderPropertyType):
        min (int): The minimum allowed property value. For properties of type &#x60;string&#x60; the validation checks the length of the property value
        max (int): The maximum allowed property value. For properties of type &#x60;string&#x60; the validation checks the length of the property value
        allowed_values (List[str]): List of allowed values for the property. If empty, any value is allowed
    """

    required: StrictBool = Field(description="Defines if the property is required")
    type: CloudProviderPropertyType
    min: StrictInt = Field(
        description="The minimum allowed property value. For properties of type `string` the validation checks the length of the property value"
    )
    max: StrictInt = Field(
        description="The maximum allowed property value. For properties of type `string` the validation checks the length of the property value"
    )
    allowed_values: List[StrictStr] = Field(
        description="List of allowed values for the property. If empty, any value is allowed"
    )


class CloudProviderPropertyValidationPlain(TypedDict, total=False):
    """
    Plain version of CloudProviderPropertyValidation.
    """

    required: Required[bool]
    type: Required[
        Union[
            CloudProviderPropertyType,
            CloudProviderPropertyTypePlain,
        ]
    ]
    min: Required[int]
    max: Required[int]
    allowed_values: Required[List[str]]
