"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .cloud_provider_service_code import (
    CloudProviderServiceCode,
    CloudProviderServiceCodePlain,
)
from .cloud_provider_service_region import (
    CloudProviderServiceRegion,
    CloudProviderServiceRegionPlain,
)
from .cloud_provider_service_resource_type import (
    CloudProviderServiceResourceType,
    CloudProviderServiceResourceTypePlain,
)
from .provider_relation import ProviderRelation, ProviderRelationPlain


class CloudProviderService(DevopnessBaseModel):
    """
    CloudProviderService

    Attributes:
        code (CloudProviderServiceCode):
        name (str): The full name of the cloud service
        provider (ProviderRelation, optional):
        regions (List[CloudProviderServiceRegion], optional):
        resource_types (List[CloudProviderServiceResourceType], optional):
    """

    code: CloudProviderServiceCode
    name: StrictStr = Field(description="The full name of the cloud service")
    provider: Optional[ProviderRelation] = None
    regions: Optional[List[CloudProviderServiceRegion]] = None
    resource_types: Optional[List[CloudProviderServiceResourceType]] = None


class CloudProviderServicePlain(TypedDict, total=False):
    """
    Plain version of CloudProviderService.
    """

    code: Required[
        Union[
            CloudProviderServiceCode,
            CloudProviderServiceCodePlain,
        ]
    ]
    name: Required[str]
    provider: Optional[
        Union[
            ProviderRelation,
            ProviderRelationPlain,
        ]
    ]
    regions: Optional[
        List[
            Union[
                CloudProviderServiceRegion,
                CloudProviderServiceRegionPlain,
            ]
        ]
    ]
    resource_types: Optional[
        List[
            Union[
                CloudProviderServiceResourceType,
                CloudProviderServiceResourceTypePlain,
            ]
        ]
    ]
