"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictStr

from .. import DevopnessBaseModel
from .cloud_provider_input_settings import (
    CloudProviderInputSettings,
    CloudProviderInputSettingsPlain,
)
from .cloud_provider_service_resource_type_scope import (
    CloudProviderServiceResourceTypeScope,
    CloudProviderServiceResourceTypeScopePlain,
)
from .operating_system import OperatingSystem, OperatingSystemPlain
from .operation_custom_settings import (
    OperationCustomSettings,
    OperationCustomSettingsPlain,
)


class CloudProviderServiceResourceType(DevopnessBaseModel):
    """
    CloudProviderServiceResourceType

    Attributes:
        provider_resource_type (str): The resource type&#39;s name on the cloud provider
        devopness_resource_type (str): The resource type&#39;s name on Devopness
        scope (CloudProviderServiceResourceTypeScope):
        input_settings (List[CloudProviderInputSettings]): Settings of the cloud provider credential
        os (List[OperatingSystem], optional):
        can_keep_disk_after_delete_server (bool, optional): Tells if this cloud service allows keeping server&#39;s persistent disks after a server is deleted. If true, Devopness API will allow users to send a parameter when deleting a server to indicate if the server persistent disks must be retained, keeping data in the disk volumes - possibly incurring extra costs on the user&#39;s cloud provider account. For cloud services that do not support this option, server disks will always be deleted when a server is deleted.
        operation_custom_settings (OperationCustomSettings, optional):
    """

    provider_resource_type: StrictStr = Field(
        description="The resource type's name on the cloud provider"
    )
    devopness_resource_type: StrictStr = Field(
        description="The resource type's name on Devopness"
    )
    scope: CloudProviderServiceResourceTypeScope
    input_settings: List[CloudProviderInputSettings] = Field(
        description="Settings of the cloud provider credential"
    )
    os: Optional[List[OperatingSystem]] = None
    can_keep_disk_after_delete_server: Optional[StrictBool] = Field(
        default=None,
        description="Tells if this cloud service allows keeping server's persistent disks after a server is deleted. If true, Devopness API will allow users to send a parameter when deleting a server to indicate if the server persistent disks must be retained, keeping data in the disk volumes - possibly incurring extra costs on the user's cloud provider account. For cloud services that do not support this option, server disks will always be deleted when a server is deleted.",
    )
    operation_custom_settings: Optional[OperationCustomSettings] = None


class CloudProviderServiceResourceTypePlain(TypedDict, total=False):
    """
    Plain version of CloudProviderServiceResourceType.
    """

    provider_resource_type: Required[str]
    devopness_resource_type: Required[str]
    scope: Required[
        Union[
            CloudProviderServiceResourceTypeScope,
            CloudProviderServiceResourceTypeScopePlain,
        ]
    ]
    input_settings: Required[
        List[
            Union[
                CloudProviderInputSettings,
                CloudProviderInputSettingsPlain,
            ]
        ]
    ]
    os: Optional[
        List[
            Union[
                OperatingSystem,
                OperatingSystemPlain,
            ]
        ]
    ]
    can_keep_disk_after_delete_server: Optional[bool]
    operation_custom_settings: Optional[
        Union[
            OperationCustomSettings,
            OperationCustomSettingsPlain,
        ]
    ]
