"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictStr

from .. import DevopnessBaseModel
from .credential_input_settings import (
    CredentialInputSettings,
    CredentialInputSettingsPlain,
)
from .provider_code import ProviderCode, ProviderCodePlain
from .provider_type import ProviderType, ProviderTypePlain


class CredentialEnvironmentCreate(DevopnessBaseModel):
    """
    CredentialEnvironmentCreate

    Attributes:
        name (str): The name of the credential. Must not be greater than 60 characters.
        provider_code (ProviderCode):
        provider_type (ProviderType):
        active (bool): If this credential is active or not.
        settings (CredentialInputSettings):
    """

    name: StrictStr = Field(
        description="The name of the credential. Must not be greater than 60 characters."
    )
    provider_code: ProviderCode
    provider_type: ProviderType
    active: StrictBool = Field(description="If this credential is active or not.")
    settings: CredentialInputSettings


class CredentialEnvironmentCreatePlain(TypedDict, total=False):
    """
    Plain version of CredentialEnvironmentCreate.
    """

    name: Required[str]
    provider_code: Required[
        Union[
            ProviderCode,
            ProviderCodePlain,
        ]
    ]
    provider_type: Required[
        Union[
            ProviderType,
            ProviderTypePlain,
        ]
    ]
    active: Required[bool]
    settings: Required[
        Union[
            CredentialInputSettings,
            CredentialInputSettingsPlain,
        ]
    ]
