"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt

from .. import DevopnessBaseModel
from .credential_provider_type import (
    CredentialProviderType,
    CredentialProviderTypePlain,
)
from .provider_settings import ProviderSettings, ProviderSettingsPlain


class CredentialSetting(DevopnessBaseModel):
    """
    CredentialSetting

    Attributes:
        provider (CredentialProviderType):
        environment_id (int): Numeric ID of the environment to which the network belongs to
        settings (ProviderSettings):
    """

    provider: CredentialProviderType
    environment_id: StrictInt = Field(
        description="Numeric ID of the environment to which the network belongs to"
    )
    settings: ProviderSettings


class CredentialSettingPlain(TypedDict, total=False):
    """
    Plain version of CredentialSetting.
    """

    provider: Required[
        Union[
            CredentialProviderType,
            CredentialProviderTypePlain,
        ]
    ]
    environment_id: Required[int]
    settings: Required[
        Union[
            ProviderSettings,
            ProviderSettingsPlain,
        ]
    ]
