"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

import json
from enum import Enum
from typing import Literal, Self


class CronJobPattern(str, Enum):
    """
    A translation of the cron expression to a readable string indicating its execution frequency.
    """

    EVERY_MINUTE = "Every minute"
    HOURLY = "Hourly"
    DAILY = "Daily"
    TWICE_A_DAY = "Twice a day"
    WEEKLY = "Weekly"
    MONTHLY = "Monthly"
    YEARLY = "Yearly"

    def __str__(self) -> str:
        """Return the string representation of the CronJobPattern"""
        return self.value

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CronJobPattern from a JSON string"""
        return cls(json.loads(json_str))


# The plain version of CronJobPattern
CronJobPatternPlain = Literal[
    "Every minute",
    "Hourly",
    "Daily",
    "Twice a day",
    "Weekly",
    "Monthly",
    "Yearly",
]
