"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation_shallow import ActionRelationShallow, ActionRelationShallowPlain
from .application_relation import ApplicationRelation, ApplicationRelationPlain
from .cron_job_pattern import CronJobPattern, CronJobPatternPlain
from .user_relation import UserRelation, UserRelationPlain


class CronJobRelation(DevopnessBaseModel):
    """
    CronJobRelation

    Attributes:
        id (int): The ID of the given cron job
        name (str): The name of the cron job
        command (str): The command line to be executed when running the cron job
        run_as_user (str): The name of the Unix user on behalf of which the cron job will be executed
        pattern (str): A cron expression consisting of Minute, Hour, Day of Month, Month and Day of Week subexpressions
        pattern_human_readable (CronJobPattern):
        is_auto_generated (bool): Indicates if the cron job was auto_generated by &#x60;Devopness&#x60; itself
        last_action (ActionRelationShallow, optional, nullable):
        created_by_user (UserRelation, optional):
        application (ApplicationRelation, optional, nullable):
        created_at (str, optional): The date and time when the record was created
        updated_at (str, optional): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The ID of the given cron job")
    name: StrictStr = Field(description="The name of the cron job")
    command: StrictStr = Field(
        description="The command line to be executed when running the cron job"
    )
    run_as_user: StrictStr = Field(
        description="The name of the Unix user on behalf of which the cron job will be executed"
    )
    pattern: StrictStr = Field(
        description="A cron expression consisting of Minute, Hour, Day of Month, Month and Day of Week subexpressions"
    )
    pattern_human_readable: CronJobPattern
    is_auto_generated: StrictBool = Field(
        description="Indicates if the cron job was auto_generated by `Devopness` itself"
    )
    last_action: Optional[ActionRelationShallow] = None
    created_by_user: Optional[UserRelation] = None
    application: Optional[ApplicationRelation] = None
    created_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was last updated"
    )


class CronJobRelationPlain(TypedDict, total=False):
    """
    Plain version of CronJobRelation.
    """

    id: Required[int]
    name: Required[str]
    command: Required[str]
    run_as_user: Required[str]
    pattern: Required[str]
    pattern_human_readable: Required[
        Union[
            CronJobPattern,
            CronJobPatternPlain,
        ]
    ]
    is_auto_generated: Required[bool]
    last_action: Optional[
        Union[
            ActionRelationShallow,
            ActionRelationShallowPlain,
        ]
    ]
    created_by_user: Optional[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    application: Optional[
        Union[
            ApplicationRelation,
            ApplicationRelationPlain,
        ]
    ]
    created_at: Optional[str]
    updated_at: Optional[str]
