"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation_shallow import ActionRelationShallow, ActionRelationShallowPlain
from .application_relation import ApplicationRelation, ApplicationRelationPlain
from .user_relation import UserRelation, UserRelationPlain


class DaemonRelation(DevopnessBaseModel):
    """
    DaemonRelation

    Attributes:
        id (int): The ID of the given daemon
        name (str): The name entered by the user (or auto-generated by &#x60;devopness&#x60;) to uniquely identify the daemon
        command (str): The command line to be executed to start the daemon
        run_as_user (str): The name of the Unix user on behalf of which the daemon will be executed
        working_directory (str, optional, nullable): The working directory where the Daemon command will be executed. If the Daemon is linked to an application, the path must be a relative path to the application root directory. If the Daemon is not linked to an application, the value must be an absolute path. Must not be greater than 255 characters
        process_count (int): The number of daemon process instances of the program to run simultaneously
        is_auto_generated (bool): Indicates if the daemon was auto_generated by &#x60;Devopness&#x60; itself
        last_action (ActionRelationShallow, optional, nullable):
        application (ApplicationRelation, optional, nullable):
        created_by_user (UserRelation, optional):
        created_at (str, optional): The date and time when the record was created
        updated_at (str, optional): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The ID of the given daemon")
    name: StrictStr = Field(
        description="The name entered by the user (or auto-generated by `devopness`) to uniquely identify the daemon"
    )
    command: StrictStr = Field(
        description="The command line to be executed to start the daemon"
    )
    run_as_user: StrictStr = Field(
        description="The name of the Unix user on behalf of which the daemon will be executed"
    )
    working_directory: Optional[StrictStr] = Field(
        description="The working directory where the Daemon command will be executed. If the Daemon is linked to an application, the path must be a relative path to the application root directory. If the Daemon is not linked to an application, the value must be an absolute path. Must not be greater than 255 characters"
    )
    process_count: StrictInt = Field(
        description="The number of daemon process instances of the program to run simultaneously"
    )
    is_auto_generated: StrictBool = Field(
        description="Indicates if the daemon was auto_generated by `Devopness` itself"
    )
    last_action: Optional[ActionRelationShallow] = None
    application: Optional[ApplicationRelation]
    created_by_user: Optional[UserRelation] = None
    created_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was last updated"
    )


class DaemonRelationPlain(TypedDict, total=False):
    """
    Plain version of DaemonRelation.
    """

    id: Required[int]
    name: Required[str]
    command: Required[str]
    run_as_user: Required[str]
    working_directory: Optional[str]
    process_count: Required[int]
    is_auto_generated: Required[bool]
    last_action: Optional[
        Union[
            ActionRelationShallow,
            ActionRelationShallowPlain,
        ]
    ]
    application: Optional[
        Union[
            ApplicationRelation,
            ApplicationRelationPlain,
        ]
    ]
    created_by_user: Optional[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    created_at: Optional[str]
    updated_at: Optional[str]
