"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .deployment_type import DeploymentType, DeploymentTypePlain


class DeploymentApplicationCreate(DevopnessBaseModel):
    """
    DeploymentApplicationCreate

    Attributes:
        environment (str, optional): The environment type of the deployment.
        type (DeploymentType):
        source_type (str, optional): The &#39;source type&#39; from which the application source code will be retrieved and deployed. It can be one of &#x60;branch&#x60;, &#x60;tag&#x60; or &#x60;commit&#x60;. If not provided, the application&#39;s default branch will be used. This field is required when &lt;code&gt;source_ref&lt;/code&gt; is present.
        source_ref (str, optional): A git reference pointing to a commit in a source provider repository from which the application source code will be retrieved and deployed. It can be a branch name, tag name or a specific commit hash. This field is required when &lt;code&gt;source_type&lt;/code&gt; is present. Must not be greater than 200 characters.
        pipeline_id (int, optional): The pipeline&#39;s ID to use for deployment.
        servers (List[int], optional): List of valid resource IDs
    """

    environment: Optional[StrictStr] = Field(
        default=None, description="The environment type of the deployment."
    )
    type: DeploymentType
    source_type: Optional[StrictStr] = Field(
        default=None,
        description="The 'source type' from which the application source code will be retrieved and deployed. It can be one of `branch`, `tag` or `commit`. If not provided, the application's default branch will be used. This field is required when <code>source_ref</code> is present.",
    )
    source_ref: Optional[StrictStr] = Field(
        default=None,
        description="A git reference pointing to a commit in a source provider repository from which the application source code will be retrieved and deployed. It can be a branch name, tag name or a specific commit hash. This field is required when <code>source_type</code> is present. Must not be greater than 200 characters.",
    )
    pipeline_id: Optional[StrictInt] = Field(
        default=None, description="The pipeline's ID to use for deployment."
    )
    servers: Optional[List[StrictInt]] = Field(
        default=None, description="List of valid resource IDs"
    )


class DeploymentApplicationCreatePlain(TypedDict, total=False):
    """
    Plain version of DeploymentApplicationCreate.
    """

    environment: Optional[str]
    type: Required[
        Union[
            DeploymentType,
            DeploymentTypePlain,
        ]
    ]
    source_type: Optional[str]
    source_ref: Optional[str]
    pipeline_id: Optional[int]
    servers: Optional[List[int]]
