"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_type import ActionType, ActionTypePlain
from .hook_settings import HookSettings, HookSettingsPlain
from .hook_trigger_when import HookTriggerWhen, HookTriggerWhenPlain
from .hook_type import HookType, HookTypePlain
from .resource_type import ResourceType, ResourceTypePlain


class HookRelation(DevopnessBaseModel):
    """
    HookRelation

    Attributes:
        id (str): The UUID of the given hook
        name (str): The name entered by the user (or auto-generated by &#x60;Devopness&#x60;) to uniquely identify the hook
        type (HookType):
        action_type (ActionType):
        url (str, optional, nullable): URL that triggers incoming hooks
        target_url (str, optional, nullable): URL that outgoing hooks make a request to
        is_auto_generated (bool): Indicates if the record was auto_generated by &#x60;Devopness&#x60; itself
        requires_secret (bool): Tells if requests to this hook must only be accepted when a HTTP header is sent with a message authentication code ([HMAC](https://en.wikipedia.org/wiki/HMAC)) generated based on the secret provided by Devopness and shared by user with external sources
        verify_ssl (bool): Indicates if the Devopness must be verify the SSL certificate of the request
        active (bool): Determines if the hook is currently active
        project_id (int): The ID of the project
        environment_id (int): The ID of the environment
        pipeline_id (int, optional, nullable): The ID of the pipeline executed by this hook
        resource_type (ResourceType):
        resource_id (int): The hooks&#39; resource ID
        settings (HookSettings, optional, nullable):
        trigger_when (HookTriggerWhen):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictStr = Field(description="The UUID of the given hook")
    name: StrictStr = Field(
        description="The name entered by the user (or auto-generated by `Devopness`) to uniquely identify the hook"
    )
    type: HookType
    action_type: ActionType
    url: Optional[StrictStr] = Field(description="URL that triggers incoming hooks")
    target_url: Optional[StrictStr] = Field(
        description="URL that outgoing hooks make a request to"
    )
    is_auto_generated: StrictBool = Field(
        description="Indicates if the record was auto_generated by `Devopness` itself"
    )
    requires_secret: StrictBool = Field(
        description="Tells if requests to this hook must only be accepted when a HTTP header is sent with a message authentication code ([HMAC](https://en.wikipedia.org/wiki/HMAC)) generated based on the secret provided by Devopness and shared by user with external sources"
    )
    verify_ssl: StrictBool = Field(
        description="Indicates if the Devopness must be verify the SSL certificate of the request"
    )
    active: StrictBool = Field(description="Determines if the hook is currently active")
    project_id: StrictInt = Field(description="The ID of the project")
    environment_id: StrictInt = Field(description="The ID of the environment")
    pipeline_id: Optional[StrictInt] = Field(
        description="The ID of the pipeline executed by this hook"
    )
    resource_type: ResourceType
    resource_id: StrictInt = Field(description="The hooks' resource ID")
    settings: Optional[HookSettings]
    trigger_when: HookTriggerWhen
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class HookRelationPlain(TypedDict, total=False):
    """
    Plain version of HookRelation.
    """

    id: Required[str]
    name: Required[str]
    type: Required[
        Union[
            HookType,
            HookTypePlain,
        ]
    ]
    action_type: Required[
        Union[
            ActionType,
            ActionTypePlain,
        ]
    ]
    url: Optional[str]
    target_url: Optional[str]
    is_auto_generated: Required[bool]
    requires_secret: Required[bool]
    verify_ssl: Required[bool]
    active: Required[bool]
    project_id: Required[int]
    environment_id: Required[int]
    pipeline_id: Optional[int]
    resource_type: Required[
        Union[
            ResourceType,
            ResourceTypePlain,
        ]
    ]
    resource_id: Required[int]
    settings: Optional[
        Union[
            HookSettings,
            HookSettingsPlain,
        ]
    ]
    trigger_when: Required[
        Union[
            HookTriggerWhen,
            HookTriggerWhenPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
