"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Any,
    Dict,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .hook_relation import HookRelation, HookRelationPlain


class HookRequest(DevopnessBaseModel):
    """
    HookRequest

    Attributes:
        id (str): The unique UUID of the hook request
        hook_id (str): The UUID of the hook that the request belongs to
        action_id (int, optional, nullable): The ID of the action that the request belongs to
        retry_of (str, optional, nullable): The UUID of the request that this request is a retry of
        ip_address (str): The IP address of the source that triggered the hook
        url (str): Original URL used on the request
        request_headers (object): The headers of the request
        request_body (object): The body of the request
        response_status_code (int): The response status code
        response_headers (object): The headers of the response
        response_body (object): The body of the response
        hook (HookRelation, optional, nullable):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictStr = Field(description="The unique UUID of the hook request")
    hook_id: StrictStr = Field(
        description="The UUID of the hook that the request belongs to"
    )
    action_id: Optional[StrictInt] = Field(
        description="The ID of the action that the request belongs to"
    )
    retry_of: Optional[StrictStr] = Field(
        description="The UUID of the request that this request is a retry of"
    )
    ip_address: StrictStr = Field(
        description="The IP address of the source that triggered the hook"
    )
    url: StrictStr = Field(description="Original URL used on the request")
    request_headers: Dict[str, Any] = Field(description="The headers of the request")
    request_body: Dict[str, Any] = Field(description="The body of the request")
    response_status_code: StrictInt = Field(description="The response status code")
    response_headers: Dict[str, Any] = Field(description="The headers of the response")
    response_body: Dict[str, Any] = Field(description="The body of the response")
    hook: Optional[HookRelation]
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class HookRequestPlain(TypedDict, total=False):
    """
    Plain version of HookRequest.
    """

    id: Required[str]
    hook_id: Required[str]
    action_id: Optional[int]
    retry_of: Optional[str]
    ip_address: Required[str]
    url: Required[str]
    request_headers: Required[object]
    request_body: Required[object]
    response_status_code: Required[int]
    response_headers: Required[object]
    response_body: Required[object]
    hook: Optional[
        Union[
            HookRelation,
            HookRelationPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
