"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation import ActionRelation, ActionRelationPlain
from .credential_relation import CredentialRelation, CredentialRelationPlain
from .environment_relation import EnvironmentRelation, EnvironmentRelationPlain
from .network_provision_input import NetworkProvisionInput, NetworkProvisionInputPlain
from .project_relation import ProjectRelation, ProjectRelationPlain
from .user_relation import UserRelation, UserRelationPlain


class Network(DevopnessBaseModel):
    """
    Network

    Attributes:
        id (int): The unique id of the given record
        provider_name (str): The name of the cloud provider
        provider_name_human_readable (str): The human readable version of the provider&#39;s name
        name (str): The networks&#39;s name
        provision_input (NetworkProvisionInput):
        created_by_user (UserRelation):
        project (ProjectRelation, optional, nullable):
        environment (EnvironmentRelation, optional, nullable):
        credential (CredentialRelation, optional, nullable):
        last_action (ActionRelation, optional, nullable):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique id of the given record")
    provider_name: StrictStr = Field(description="The name of the cloud provider")
    provider_name_human_readable: StrictStr = Field(
        description="The human readable version of the provider's name"
    )
    name: StrictStr = Field(description="The networks's name")
    provision_input: NetworkProvisionInput
    created_by_user: UserRelation
    project: Optional[ProjectRelation]
    environment: Optional[EnvironmentRelation]
    credential: Optional[CredentialRelation]
    last_action: Optional[ActionRelation]
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class NetworkPlain(TypedDict, total=False):
    """
    Plain version of Network.
    """

    id: Required[int]
    provider_name: Required[str]
    provider_name_human_readable: Required[str]
    name: Required[str]
    provision_input: Required[
        Union[
            NetworkProvisionInput,
            NetworkProvisionInputPlain,
        ]
    ]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    project: Optional[
        Union[
            ProjectRelation,
            ProjectRelationPlain,
        ]
    ]
    environment: Optional[
        Union[
            EnvironmentRelation,
            EnvironmentRelationPlain,
        ]
    ]
    credential: Optional[
        Union[
            CredentialRelation,
            CredentialRelationPlain,
        ]
    ]
    last_action: Optional[
        Union[
            ActionRelation,
            ActionRelationPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
