"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .network_rule_direction import NetworkRuleDirection, NetworkRuleDirectionPlain
from .network_rule_protocol import NetworkRuleProtocol, NetworkRuleProtocolPlain
from .resource_to_be_linked import ResourceToBeLinked, ResourceToBeLinkedPlain


class NetworkRuleEnvironmentCreate(DevopnessBaseModel):
    """
    NetworkRuleEnvironmentCreate

    Attributes:
        linked_resources (List[ResourceToBeLinked], optional): The resources to be linked with this resource
        name (str): The rule&#39;s name/description/reminder. Must be at least 3 characters. Must not be greater than 60 characters.
        direction (NetworkRuleDirection):
        protocol (NetworkRuleProtocol):
        cidr_block (str): IP address range this rule applies for, defined using CIDR notation.
        port (int): Network port to be considered by this rule. Must be at least 1. Must not be greater than 65535.
    """

    linked_resources: Optional[List[ResourceToBeLinked]] = Field(
        default=None, description="The resources to be linked with this resource"
    )
    name: StrictStr = Field(
        description="The rule's name/description/reminder. Must be at least 3 characters. Must not be greater than 60 characters."
    )
    direction: NetworkRuleDirection
    protocol: NetworkRuleProtocol
    cidr_block: StrictStr = Field(
        description="IP address range this rule applies for, defined using CIDR notation."
    )
    port: StrictInt = Field(
        description="Network port to be considered by this rule. Must be at least 1. Must not be greater than 65535."
    )


class NetworkRuleEnvironmentCreatePlain(TypedDict, total=False):
    """
    Plain version of NetworkRuleEnvironmentCreate.
    """

    linked_resources: Optional[
        List[
            Union[
                ResourceToBeLinked,
                ResourceToBeLinkedPlain,
            ]
        ]
    ]
    name: Required[str]
    direction: Required[
        Union[
            NetworkRuleDirection,
            NetworkRuleDirectionPlain,
        ]
    ]
    protocol: Required[
        Union[
            NetworkRuleProtocol,
            NetworkRuleProtocolPlain,
        ]
    ]
    cidr_block: Required[str]
    port: Required[int]
