"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation_shallow import ActionRelationShallow, ActionRelationShallowPlain
from .network_rule_direction import NetworkRuleDirection, NetworkRuleDirectionPlain
from .network_rule_protocol import NetworkRuleProtocol, NetworkRuleProtocolPlain


class NetworkRuleRelation(DevopnessBaseModel):
    """
    NetworkRuleRelation

    Attributes:
        id (int): The ID of the given network rule
        name (str): The rule&#39;s name/description/reminder
        direction (NetworkRuleDirection):
        protocol (NetworkRuleProtocol):
        port (int): Network port to be considered by this rule
        cidr_block (str): IP address range this rule applies for, defined using CIDR notation
        is_auto_generated (bool): Indicates if the network rule was auto_generated by &#x60;Devopness&#x60; itself
        last_action (ActionRelationShallow, optional, nullable):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The ID of the given network rule")
    name: StrictStr = Field(description="The rule's name/description/reminder")
    direction: NetworkRuleDirection
    protocol: NetworkRuleProtocol
    port: StrictInt = Field(description="Network port to be considered by this rule")
    cidr_block: StrictStr = Field(
        description="IP address range this rule applies for, defined using CIDR notation"
    )
    is_auto_generated: StrictBool = Field(
        description="Indicates if the network rule was auto_generated by `Devopness` itself"
    )
    last_action: Optional[ActionRelationShallow] = None
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class NetworkRuleRelationPlain(TypedDict, total=False):
    """
    Plain version of NetworkRuleRelation.
    """

    id: Required[int]
    name: Required[str]
    direction: Required[
        Union[
            NetworkRuleDirection,
            NetworkRuleDirectionPlain,
        ]
    ]
    protocol: Required[
        Union[
            NetworkRuleProtocol,
            NetworkRuleProtocolPlain,
        ]
    ]
    port: Required[int]
    cidr_block: Required[str]
    is_auto_generated: Required[bool]
    last_action: Optional[
        Union[
            ActionRelationShallow,
            ActionRelationShallowPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
