"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .network_rule_direction import NetworkRuleDirection, NetworkRuleDirectionPlain
from .network_rule_protocol import NetworkRuleProtocol, NetworkRuleProtocolPlain


class NetworkRuleUpdate(DevopnessBaseModel):
    """
    NetworkRuleUpdate

    Attributes:
        id (int): The unique ID of the given Network Rule.
        name (str): The rule&#39;s name/description/reminder. Must be at least 3 characters. Must not be greater than 60 characters.
        direction (NetworkRuleDirection):
        protocol (NetworkRuleProtocol, optional):
        cidr_block (str): IP address range this rule applies for, defined using CIDR notation.
    """

    id: StrictInt = Field(description="The unique ID of the given Network Rule.")
    name: StrictStr = Field(
        description="The rule's name/description/reminder. Must be at least 3 characters. Must not be greater than 60 characters."
    )
    direction: NetworkRuleDirection
    protocol: Optional[NetworkRuleProtocol] = None
    cidr_block: StrictStr = Field(
        description="IP address range this rule applies for, defined using CIDR notation."
    )


class NetworkRuleUpdatePlain(TypedDict, total=False):
    """
    Plain version of NetworkRuleUpdate.
    """

    id: Required[int]
    name: Required[str]
    direction: Required[
        Union[
            NetworkRuleDirection,
            NetworkRuleDirectionPlain,
        ]
    ]
    protocol: Optional[
        Union[
            NetworkRuleProtocol,
            NetworkRuleProtocolPlain,
        ]
    ]
    cidr_block: Required[str]
