"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .operating_system_version import (
    OperatingSystemVersion,
    OperatingSystemVersionPlain,
)


class OperatingSystem(DevopnessBaseModel):
    """
    OperatingSystem

    Attributes:
        code (str): The name of the operating system
        name (str): The formatted name of the operating system
        hint (str): Descriptive text to help users to know what data is stored in the field and optional extra information on how to enter data to the field
        supported_versions (List[OperatingSystemVersion]):
    """

    code: StrictStr = Field(description="The name of the operating system")
    name: StrictStr = Field(description="The formatted name of the operating system")
    hint: StrictStr = Field(
        description="Descriptive text to help users to know what data is stored in the field and optional extra information on how to enter data to the field"
    )
    supported_versions: List[OperatingSystemVersion]


class OperatingSystemPlain(TypedDict, total=False):
    """
    Plain version of OperatingSystem.
    """

    code: Required[str]
    name: Required[str]
    hint: Required[str]
    supported_versions: Required[
        List[
            Union[
                OperatingSystemVersion,
                OperatingSystemVersionPlain,
            ]
        ]
    ]
