"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .api_token_status import ApiTokenStatus, ApiTokenStatusPlain
from .api_token_type import ApiTokenType, ApiTokenTypePlain
from .user_relation import UserRelation, UserRelationPlain


class PersonalAccessToken(DevopnessBaseModel):
    """
    PersonalAccessToken

    Attributes:
        id (str): Unique identifier of the Token
        name (str): Name of the Token
        type (ApiTokenType):
        token (str, optional, nullable): The plain text value of the Token. The API token value is only displayed/returned once when the token is generated. Users must keep it in a safe place, as it cannot be retrieved again at a later time.
        status (ApiTokenStatus):
        user (UserRelation):
        last_used_at (str, optional, nullable): Last time the Token was used
        expires_at (str): Expiration date of the Token
        revoked_at (str, optional, nullable): Revocation date of the Token
        updated_at (str): Last time the Token was updated
        created_at (str): Creation date of the Token
    """

    id: StrictStr = Field(description="Unique identifier of the Token")
    name: StrictStr = Field(description="Name of the Token")
    type: ApiTokenType
    token: Optional[StrictStr] = Field(
        description="The plain text value of the Token. The API token value is only displayed/returned once when the token is generated. Users must keep it in a safe place, as it cannot be retrieved again at a later time."
    )
    status: ApiTokenStatus
    user: UserRelation
    last_used_at: Optional[StrictStr] = Field(
        description="Last time the Token was used"
    )
    expires_at: StrictStr = Field(description="Expiration date of the Token")
    revoked_at: Optional[StrictStr] = Field(description="Revocation date of the Token")
    updated_at: StrictStr = Field(description="Last time the Token was updated")
    created_at: StrictStr = Field(description="Creation date of the Token")


class PersonalAccessTokenPlain(TypedDict, total=False):
    """
    Plain version of PersonalAccessToken.
    """

    id: Required[str]
    name: Required[str]
    type: Required[
        Union[
            ApiTokenType,
            ApiTokenTypePlain,
        ]
    ]
    token: Optional[str]
    status: Required[
        Union[
            ApiTokenStatus,
            ApiTokenStatusPlain,
        ]
    ]
    user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    last_used_at: Optional[str]
    expires_at: Required[str]
    revoked_at: Optional[str]
    updated_at: Required[str]
    created_at: Required[str]
