"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel


class ProjectUpdate(DevopnessBaseModel):
    """
    ProjectUpdate

    Attributes:
        id (int): The unique ID of the given Project.
        name (str): The name of the project. Must not be greater than 60 characters.
        logo_image (str, optional): A base64 string representation of the logo image.
        logo_url (str, optional): A URL path to the project&#39;s logo image. Must be a valid URL.
    """

    id: StrictInt = Field(description="The unique ID of the given Project.")
    name: StrictStr = Field(
        description="The name of the project. Must not be greater than 60 characters."
    )
    logo_image: Optional[StrictStr] = Field(
        default=None, description="A base64 string representation of the logo image."
    )
    logo_url: Optional[StrictStr] = Field(
        default=None,
        description="A URL path to the project's logo image. Must be a valid URL.",
    )


class ProjectUpdatePlain(TypedDict, total=False):
    """
    Plain version of ProjectUpdate.
    """

    id: Required[int]
    name: Required[str]
    logo_image: Optional[str]
    logo_url: Optional[str]
