"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .cloud_provider_service import CloudProviderService, CloudProviderServicePlain
from .provider_input_settings import ProviderInputSettings, ProviderInputSettingsPlain


class ProviderSettings(DevopnessBaseModel):
    """
    ProviderSettings

    Attributes:
        connect_url (str, optional): The URL used to connect Devopness to a credential provider of type &#x60;source_provider&#x60;
        input_settings (List[ProviderInputSettings]): The list of input settings for credentials of specific provider
        cloud_services (List[CloudProviderService], optional):
    """

    connect_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL used to connect Devopness to a credential provider of type `source_provider`",
    )
    input_settings: List[ProviderInputSettings] = Field(
        description="The list of input settings for credentials of specific provider"
    )
    cloud_services: Optional[List[CloudProviderService]] = None


class ProviderSettingsPlain(TypedDict, total=False):
    """
    Plain version of ProviderSettings.
    """

    connect_url: Optional[str]
    input_settings: Required[
        List[
            Union[
                ProviderInputSettings,
                ProviderInputSettingsPlain,
            ]
        ]
    ]
    cloud_services: Optional[
        List[
            Union[
                CloudProviderService,
                CloudProviderServicePlain,
            ]
        ]
    ]
