"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel


class ResourceEventRelation(DevopnessBaseModel):
    """
    ResourceEventRelation

    Attributes:
        id (int): The ID of the given resource event
        event_type (str): The type of resource event
        resource_type (str): The event&#39;s resource type
        resource_id (int): The event&#39;s resource ID
        message (str, optional, nullable):
        triggered_by (int, optional, nullable):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The ID of the given resource event")
    event_type: StrictStr = Field(description="The type of resource event")
    resource_type: StrictStr = Field(description="The event's resource type")
    resource_id: StrictInt = Field(description="The event's resource ID")
    message: Optional[StrictStr]
    triggered_by: Optional[StrictInt]
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class ResourceEventRelationPlain(TypedDict, total=False):
    """
    Plain version of ResourceEventRelation.
    """

    id: Required[int]
    event_type: Required[str]
    resource_type: Required[str]
    resource_id: Required[int]
    message: Optional[str]
    triggered_by: Optional[int]
    created_at: Required[str]
    updated_at: Required[str]
