"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .linked_resource_data import LinkedResourceData, LinkedResourceDataPlain


class ResourceLinkChild(DevopnessBaseModel):
    """
    ResourceLinkChild

    Attributes:
        link_type (str): The link type to related resource (&#x60;child&#x60; or &#x60;parent&#x60;)
        resource_id (int): The linked resource ID
        resource_type (str): The linked resource type
        resource_type_human_readable (str): Human readable resource type
        can_be_unlinked (bool): If false, the link cannot be manually removed
        linked_resource_data (LinkedResourceData):
    """

    link_type: StrictStr = Field(
        description="The link type to related resource (`child` or `parent`)"
    )
    resource_id: StrictInt = Field(description="The linked resource ID")
    resource_type: StrictStr = Field(description="The linked resource type")
    resource_type_human_readable: StrictStr = Field(
        description="Human readable resource type"
    )
    can_be_unlinked: StrictBool = Field(
        description="If false, the link cannot be manually removed"
    )
    linked_resource_data: LinkedResourceData


class ResourceLinkChildPlain(TypedDict, total=False):
    """
    Plain version of ResourceLinkChild.
    """

    link_type: Required[str]
    resource_id: Required[int]
    resource_type: Required[str]
    resource_type_human_readable: Required[str]
    can_be_unlinked: Required[bool]
    linked_resource_data: Required[
        Union[
            LinkedResourceData,
            LinkedResourceDataPlain,
        ]
    ]
