"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

import json
from enum import Enum
from typing import Literal, Self


class ResourceType(str, Enum):
    """
    Type of an infrastructure resource managed through a Devopness environment.
    """

    APPLICATION = "application"
    CREDENTIAL = "credential"
    CRONJOB = "cronjob"
    DAEMON = "daemon"
    DEPLOYMENT = "deployment"
    NETWORK = "network"
    NETWORK_MINUS_RULE = "network-rule"
    SERVER = "server"
    SERVICE = "service"
    SSH_MINUS_KEY = "ssh-key"
    SSL_MINUS_CERTIFICATE = "ssl-certificate"
    SUBNET = "subnet"
    VIRTUAL_MINUS_HOST = "virtual-host"

    def __str__(self) -> str:
        """Return the string representation of the ResourceType"""
        return self.value

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ResourceType from a JSON string"""
        return cls(json.loads(json_str))


# The plain version of ResourceType
ResourceTypePlain = Literal[
    "application",
    "credential",
    "cronjob",
    "daemon",
    "deployment",
    "network",
    "network-rule",
    "server",
    "service",
    "ssh-key",
    "ssl-certificate",
    "subnet",
    "virtual-host",
]
