"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel


class RoleRelation(DevopnessBaseModel):
    """
    RoleRelation

    Attributes:
        id (int): The unique ID of the given role
        name (str): The name of the given role
        description (str): Description of this role
        project_id (int, optional, nullable): The ID of the project this role belongs to
        is_predefined (bool): Defines if the role is predefined or a custom role for specific project
        permissions (List[str]): The list of permissions granted for this role
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique ID of the given role")
    name: StrictStr = Field(description="The name of the given role")
    description: StrictStr = Field(description="Description of this role")
    project_id: Optional[StrictInt] = Field(
        description="The ID of the project this role belongs to"
    )
    is_predefined: StrictBool = Field(
        description="Defines if the role is predefined or a custom role for specific project"
    )
    permissions: List[StrictStr] = Field(
        description="The list of permissions granted for this role"
    )
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class RoleRelationPlain(TypedDict, total=False):
    """
    Plain version of RoleRelation.
    """

    id: Required[int]
    name: Required[str]
    description: Required[str]
    project_id: Optional[int]
    is_predefined: Required[bool]
    permissions: Required[List[str]]
    created_at: Required[str]
    updated_at: Required[str]
