"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

import json
from enum import Enum
from typing import Literal, Self


class ServerStatus(str, Enum):
    """
    The status of the server
    """

    CONFIGURING = "configuring"
    FAILED = "failed"
    PENDING = "pending"
    PROVISIONED = "provisioned"
    PROVISIONING = "provisioning"
    RESTARTING = "restarting"
    RUNNING = "running"
    STOPPED = "stopped"

    def __str__(self) -> str:
        """Return the string representation of the ServerStatus"""
        return self.value

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ServerStatus from a JSON string"""
        return cls(json.loads(json_str))


# The plain version of ServerStatus
ServerStatusPlain = Literal[
    "configuring",
    "failed",
    "pending",
    "provisioned",
    "provisioning",
    "restarting",
    "running",
    "stopped",
]
