"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel


class ServerUpdate(DevopnessBaseModel):
    """
    ServerUpdate

    Attributes:
        id (int): The unique ID of the given Server.
        ip_address (str, optional): Public ipv4 address for server access.
        ssh_port (int, optional): The network port to which the SSH daemon is listening to SSH connections on the server. Must be between 22 and 65535.
        max_parallel_actions (int, optional): Maximum number of actions that can run in parallel on this server. &#x60;0&#x60; means no limit of simultaneous actions. &#x60;1&#x60; means just a single action will be started at a time to run on this server. Must be between 0 and 10.
        credential_id (str, optional): The ID of the cloud credential.
    """

    id: StrictInt = Field(description="The unique ID of the given Server.")
    ip_address: Optional[StrictStr] = Field(
        default=None, description="Public ipv4 address for server access."
    )
    ssh_port: Optional[StrictInt] = Field(
        default=None,
        description="The network port to which the SSH daemon is listening to SSH connections on the server. Must be between 22 and 65535.",
    )
    max_parallel_actions: Optional[StrictInt] = Field(
        default=None,
        description="Maximum number of actions that can run in parallel on this server. `0` means no limit of simultaneous actions. `1` means just a single action will be started at a time to run on this server. Must be between 0 and 10.",
    )
    credential_id: Optional[StrictStr] = Field(
        default=None, description="The ID of the cloud credential."
    )


class ServerUpdatePlain(TypedDict, total=False):
    """
    Plain version of ServerUpdate.
    """

    id: Required[int]
    ip_address: Optional[str]
    ssh_port: Optional[int]
    max_parallel_actions: Optional[int]
    credential_id: Optional[str]
