"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictStr

from .. import DevopnessBaseModel
from .resource_to_be_linked import ResourceToBeLinked, ResourceToBeLinkedPlain
from .service_initial_state import ServiceInitialState, ServiceInitialStatePlain
from .service_type import ServiceType, ServiceTypePlain


class ServiceEnvironmentCreate(DevopnessBaseModel):
    """
    ServiceEnvironmentCreate

    Attributes:
        linked_resources (List[ResourceToBeLinked], optional): The resources to be linked with this resource
        auto_start (bool, optional): Tells if the service should start automatically on operating system boot.
        initial_state (ServiceInitialState, optional):
        type (ServiceType):
        version (str): The service version to be installed. Must be at least 1 character. Must not be greater than 30 characters.
    """

    linked_resources: Optional[List[ResourceToBeLinked]] = Field(
        default=None, description="The resources to be linked with this resource"
    )
    auto_start: Optional[StrictBool] = Field(
        default=None,
        description="Tells if the service should start automatically on operating system boot.",
    )
    initial_state: Optional[ServiceInitialState] = ServiceInitialState.STARTED
    type: ServiceType
    version: StrictStr = Field(
        description="The service version to be installed. Must be at least 1 character. Must not be greater than 30 characters."
    )


class ServiceEnvironmentCreatePlain(TypedDict, total=False):
    """
    Plain version of ServiceEnvironmentCreate.
    """

    linked_resources: Optional[
        List[
            Union[
                ResourceToBeLinked,
                ResourceToBeLinkedPlain,
            ]
        ]
    ]
    auto_start: Optional[bool]
    initial_state: Optional[
        Union[
            ServiceInitialState,
            ServiceInitialStatePlain,
        ]
    ]
    type: Required[
        Union[
            ServiceType,
            ServiceTypePlain,
        ]
    ]
    version: Required[str]
