"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation import ActionRelation, ActionRelationPlain
from .environment_relation import EnvironmentRelation, EnvironmentRelationPlain
from .server_relation import ServerRelation, ServerRelationPlain
from .user_relation import UserRelation, UserRelationPlain


class SshKey(DevopnessBaseModel):
    """
    SshKey

    Attributes:
        id (int): The Id of the given SSH public key
        created_by (int, optional): The id of the user to which the SSH key belongs to
        project_id (int, optional): The project id to which the SSH public key belongs to
        environment_id (int): The environment id to which the SSH public key belongs to
        name (str): The name entered by the user to uniquely identify the public SSH key
        fingerprint (str): The hashed fingerprint of the public key
        created_by_user (UserRelation):
        environment (EnvironmentRelation, optional, nullable):
        servers (List[ServerRelation]):
        last_action (ActionRelation, optional, nullable):
        created_at (str, optional): The date and time when the record was created
        updated_at (str, optional): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The Id of the given SSH public key")
    created_by: Optional[StrictInt] = Field(
        default=None, description="The id of the user to which the SSH key belongs to"
    )
    project_id: Optional[StrictInt] = Field(
        default=None,
        description="The project id to which the SSH public key belongs to",
    )
    environment_id: StrictInt = Field(
        description="The environment id to which the SSH public key belongs to"
    )
    name: StrictStr = Field(
        description="The name entered by the user to uniquely identify the public SSH key"
    )
    fingerprint: StrictStr = Field(
        description="The hashed fingerprint of the public key"
    )
    created_by_user: UserRelation
    environment: Optional[EnvironmentRelation]
    servers: List[Optional[ServerRelation]]
    last_action: Optional[ActionRelation]
    created_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was last updated"
    )


class SshKeyPlain(TypedDict, total=False):
    """
    Plain version of SshKey.
    """

    id: Required[int]
    created_by: Optional[int]
    project_id: Optional[int]
    environment_id: Required[int]
    name: Required[str]
    fingerprint: Required[str]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    environment: Optional[
        Union[
            EnvironmentRelation,
            EnvironmentRelationPlain,
        ]
    ]
    servers: Required[
        List[
            Union[
                ServerRelation,
                ServerRelationPlain,
            ]
        ]
    ]
    last_action: Optional[
        Union[
            ActionRelation,
            ActionRelationPlain,
        ]
    ]
    created_at: Optional[str]
    updated_at: Optional[str]
